
<?php
require_once 'config.php';
$user = verifyAuth();

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    exit;
}

$data = json_decode(file_get_contents('php://input'), true);
$planId = $data['planId'] ?? 'starter';
$method = $data['method'] ?? 'stripe';

$plans = [
    'starter' => ['price' => 49, 'credits' => 10000, 'name' => 'Starter Plan'],
    'pro' => ['price' => 129, 'credits' => 50000, 'name' => 'Professional Plan'],
    'enterprise' => ['price' => 499, 'credits' => 500000, 'name' => 'Enterprise Plan']
];

if (!isset($plans[$planId])) {
    http_response_code(400);
    echo json_encode(['error' => 'Invalid plan selected']);
    exit;
}

$selectedPlan = $plans[$planId];

if ($method === 'stripe') {
    // Initiate Stripe Checkout via cURL (to avoid requiring the SDK if not present)
    $ch = curl_init('https://api.stripe.com/v1/checkout/sessions');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_USERPWD, STRIPE_SECRET_KEY . ':');
    curl_setopt($ch, CURLOPT_POST, true);
    
    $postData = [
        'payment_method_types' => ['card'],
        'line_items' => [[
            'price_data' => [
                'currency' => 'usd',
                'product_data' => [
                    'name' => 'Mailvity - ' . $selectedPlan['name'],
                    'description' => $selectedPlan['credits'] . ' Verification Credits',
                ],
                'unit_amount' => $selectedPlan['price'] * 100,
            ],
            'quantity' => 1,
        ]],
        'mode' => 'payment',
        'success_url' => 'https://mailvity.cc/#/dashboard?payment=success',
        'cancel_url' => 'https://mailvity.cc/#/billing?payment=cancelled',
        'client_reference_id' => $user['id'],
        'metadata' => [
            'plan' => $planId,
            'credits' => $selectedPlan['credits']
        ]
    ];
    
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($postData));
    $response = curl_exec($ch);
    $session = json_decode($response, true);
    curl_close($ch);

    if (isset($session['url'])) {
        echo json_encode(['url' => $session['url']]);
    } else {
        http_response_code(500);
        echo json_encode(['error' => 'Stripe session creation failed', 'details' => $session]);
    }
} else if ($method === 'crypto') {
    // Placeholder for a crypto gateway like NowPayments or Coinbase Commerce
    // You would call their API similarly here
    echo json_encode(['url' => 'https://mailvity.cc/#/billing/crypto-instructions?amount=' . $selectedPlan['price']]);
}
?>
