
<?php
require_once 'config.php';
$user = verifyAuth();
try {
    $stmt = $pdo->prepare("SELECT j.id, j.total_emails, j.status, j.created_at, 
        (SELECT COUNT(*) FROM verification_results WHERE job_id = j.id AND status = 'Valid') as valid,
        (SELECT COUNT(*) FROM verification_results WHERE job_id = j.id AND status = 'Invalid') as invalid
        FROM verification_jobs j WHERE j.user_id = ? ORDER BY j.created_at DESC LIMIT 50");
    $stmt->execute([$user['id']]);
    echo json_encode($stmt->fetchAll());
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Internal Server Error']);
}
?>
