
<?php
require_once 'config.php';

// Secure download access using temporary token validation
$token = $_GET['token'] ?? null;
if (!$token) { http_response_code(401); exit; }
$user = decodeJWT($token);
if (!$user) { http_response_code(401); exit; }

$jobId = $_GET['jobId'] ?? null;
$type = $_GET['type'] ?? 'csv';

if (!$jobId) { http_response_code(400); exit; }

// Validate ownership of the data before export
$stmt = $pdo->prepare("SELECT id FROM verification_jobs WHERE id = ? AND user_id = ?");
$stmt->execute([$jobId, $user['id']]);
if (!$stmt->fetch()) { http_response_code(403); exit; }

$stmt = $pdo->prepare("SELECT email, status, confidence, reason FROM verification_results WHERE job_id = ?");
$stmt->execute([$jobId]);
$results = $stmt->fetchAll();

if ($type === 'csv') {
    header('Content-Type: text/csv');
    header('Content-Disposition: attachment; filename="mailvity_export_' . $jobId . '.csv"');
    $output = fopen('php://output', 'w');
    fputcsv($output, ['Email', 'Status', 'AI Confidence', 'Technical Reason']);
    foreach ($results as $row) { fputcsv($output, $row); }
    fclose($output);
} else {
    header('Content-Type: text/plain');
    header('Content-Disposition: attachment; filename="mailvity_export_' . $jobId . '.txt"');
    foreach ($results as $row) { echo $row['email'] . "\r\n"; }
}
exit;
?>
