
import React from 'react';
import { User } from '../types';
import { Search, Bell, Mail } from 'lucide-react';

interface NavbarProps {
  user: User | null;
}

const Navbar: React.FC<NavbarProps> = ({ user }) => {
  return (
    <header className="h-16 bg-white border-b border-slate-200 flex items-center justify-between px-8 sticky top-0 z-10">
      <div className="flex items-center flex-1">
        <div className="relative w-64 hidden md:block">
          <Search className="absolute left-3 top-1/2 -translate-y-1/2 text-slate-400" size={18} />
          <input 
            type="text" 
            placeholder="Search leads..." 
            className="w-full pl-10 pr-4 py-2 bg-slate-100 border-none rounded-full text-sm focus:ring-2 focus:ring-indigo-500 focus:bg-white transition-all"
          />
        </div>
      </div>

      <div className="flex items-center space-x-6">
        <div className="hidden lg:flex items-center space-x-4">
          <div className="text-right">
            <p className="text-xs text-slate-500 font-medium uppercase tracking-wider">Credits</p>
            <p className="text-sm font-bold text-slate-900">{user?.credits?.toLocaleString() || 0}</p>
          </div>
          <div className="h-8 w-px bg-slate-200" />
          <div className="text-right">
            <p className="text-xs text-slate-500 font-medium uppercase tracking-wider">Plan</p>
            <p className="text-sm font-bold text-indigo-600 uppercase italic">{user?.plan || 'Free'}</p>
          </div>
        </div>

        <div className="flex items-center space-x-2">
          <button className="p-2 text-slate-400 hover:text-slate-600 hover:bg-slate-100 rounded-full transition-colors relative">
            <Bell size={20} />
            <span className="absolute top-2 right-2 w-2 h-2 bg-red-500 rounded-full border-2 border-white"></span>
          </button>
          
          <div className="flex items-center space-x-3 pl-4 border-l border-slate-200">
            <div className="w-9 h-9 bg-indigo-100 text-indigo-700 flex items-center justify-center rounded-full font-bold text-sm">
              {user?.email?.charAt(0).toUpperCase() || 'U'}
            </div>
            <div className="hidden sm:block">
              <p className="text-sm font-semibold text-slate-900 leading-tight truncate max-w-[120px]">
                {user?.email?.split('@')[0]}
              </p>
              <p className="text-xs text-slate-500 leading-tight">Active Session</p>
            </div>
          </div>
        </div>
      </div>
    </header>
  );
};

export default Navbar;
